<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Admin\Category;
use App\Models\Admin\Continent;
use App\Models\Admin\Country;
use App\Models\Admin\JobFee;
use App\Models\Admin\LocationZone;
use App\Models\Admin\LocationZoneCountry;
use App\Models\Admin\MainWallet;
use App\Models\Admin\SubCategory;
use App\Models\Admin\Website;
use App\Models\BoostCharge;
use App\Models\BoostJob;
use App\Models\Job;
use App\Models\JobCountry;
use App\Models\User;
use App\Models\Admin\UserMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class UserJobController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    

    public function index()
    {
        job_delete(Auth::user()->id);
        $datas = Job::where('user_id', Auth::user()->id)->latest()->take(250)->get();
        $title = 'Job List';

        return view('user.pages.job-list', compact('title', 'datas'));
    }

    public function get_recent_job(Request $request)
    {
        $html = '';
        $jobs = Job::orderBy('id', 'DESC')->where('status', 1)->limit(100)->get();
        $totalFound = $jobs->count();

     //   $html .= '<h6 class="text-center">Total Found: ' . $totalFound . '</h6>';

        
        if($jobs->count() > 0){
            foreach ($jobs as $key=>$job){
                if ($job->worker_need > $job->worker_confirmed && $job->worker_need > complete_work_this_job($job->id) && work_by_me($job->id) == 0 && work_for_me($job->id) == 1 && $job->pause == 0){
                    $html .= '
                            <a href="'.route('job-details', $job->code).'"
                           
                                <div class="border p-1 mb-2 row job-area">
                                	<div class="col-lg-4 col-md-5 col-12 job_title" style="color: '. (this_job_complet_rate($job->id) <= 95 ? 'black' : '#2ECC71') .'; font-weight: 500; font-size: 16px;">'. $job->title .'</div>
                                	
                                		<div class="col-lg-6 col-md-5 col-8">
                                			<div class="row m-0 justify-content-end">
                                				<div class="col-lg-6 col-md-5 col-6">
                                                	<div class="text-center mx-auto">
                                                		<h6 class="mt-1" style="color: black; font-size: 10px; font-weight: 250;">
                                                			'. complete_work_this_job($job->id) .' OF '. $job->worker_need .'
                                                		</h6>
                                                        <div class="progress progress-md p-0">
                                                            <div class="progress-bar" style="width: '. this_job_complet_rate($job->id) .'%; background-color: '. (this_job_complet_rate($job->id) <= 50 ? '#17a2b8' : '#22ab59') .';"></div>
                                                		</div>
                                                	</div>
                                                </div>
                                			</div>
                                		</div>
                                	<div class="col-lg-2 col-md-2 col-4 text-center text-success">
                                	<h5 style="color: #2ECC71; font-size: 15px;">
                                		'. number_format($job->each_worker_earn, 4) .' $
                                	</h5>
                                </div>
                                
                                </div>
                            </a>
                    ';
                }
            }
        }

        return $html;
    }

    public function get_heigh_cost_job(Request $request)
    {
        $html = '';
        $jobs = Job::orderBy('each_worker_earn', 'DESC')->where('status', 1)->limit(100)->get();

      //  $html .= '<h4 class="text-center"><strong>Total Found: '.job_found().'</strong></h4>';

        if($jobs->count() > 0){
            foreach ($jobs as $key=>$job){
                if ($job->worker_need > $job->worker_confirmed && $job->worker_need > complete_work_this_job($job->id) && work_by_me($job->id) == 0 && work_for_me($job->id) == 1 && $job->pause == 0){
                    $html .= '
                            <a href="'.route('job-details', $job->code).'">
                                <div class="border p-1 mb-2 row job-area">
                                	<div class="col-lg-4 col-md-5 col-12 job_title" style="color: '. (this_job_complet_rate($job->id) <= 95 ? 'black' : '#2ECC71') .'; font-weight: 500; font-size: 16px;">'. $job->title .'</div>
                                		<div class="col-lg-6 col-md-5 col-8">
                                			<div class="row m-0 justify-content-end">
                                				<div class="col-lg-6 col-md-5 col-6">
                                                	<div class="text-center mx-auto">
                                                		<h6 class="mt-1" style="color: black; font-size: 10px; font-weight: 250;">
                                                			'. complete_work_this_job($job->id) .' OF '. $job->worker_need .'
                                                		</h6>
                                                		<div class="progress progress-md p-0">
                                                			<div class="progress-bar" style="width: '. this_job_complet_rate($job->id) .'%; background-color: '. (this_job_complet_rate($job->id) <= 50 ? '#17a2b8' : '#22ab59') .';"></div>
                                                		</div>
                                                	</div>
                                                </div>
                                			</div>
                                		</div>
                                	<div class="col-lg-2 col-md-2 col-4 text-center text-success">
                                	<h5 style="color: #2ECC71; font-size: 15px;">
                                		'. number_format($job->each_worker_earn, 4) .' $
                                	</h5>
                                </div>
                                
                                </div>
                            </a>
                    ';
                }
            }
        }

        return $html;
    }

    public function get_job_country_wise(Request $request)
    {
        $country_id = $request->country_id;
        $html = '';
        $jobs = Job::where('continent_id', $country_id)->where('status', 1)->latest()->limit(100)->get();
        
        $country_wise_total_found = $jobs->filter(function ($job) {
        return $job->worker_need > $job->worker_confirmed && 
               $job->worker_need > complete_work_this_job($job->id) && 
               work_by_me($job->id) == 0 && 
               work_for_me($job->id) == 1 && $job->pause == 0;
        })->count();

        $html .= '<h6 class="text-center">Total Found: ' . $country_wise_total_found . '</h6>';
        
        if($jobs->count() > 0){
            foreach ($jobs as $key=>$job){
                if ($job->worker_need > $job->worker_confirmed && $job->worker_need > complete_work_this_job($job->id) && work_by_me($job->id) == 0 && work_for_me($job->id) == 1 && $job->pause == 0){
                    $html .= '
                            <a href="'.route('job-details', $job->code).'">
                                <div class="border p-1 mb-2 row job-area">
                                	<div class="col-lg-4 col-md-5 col-12 job_title" style="color: '. (this_job_complet_rate($job->id) <= 95 ? 'black' : '#2ECC71') .'; font-weight: 500; font-size: 16px;">'. $job->title .'</div>
                                		<div class="col-lg-6 col-md-5 col-8">
                                			<div class="row m-0 justify-content-end">
                                				<div class="col-lg-6 col-md-5 col-6">
                                                	<div class="text-center mx-auto">
                                                		<h6 class="mt-1" style="color: black; font-size: 10px; font-weight: 250;">
                                                			'. complete_work_this_job($job->id) .' OF '. $job->worker_need .'
                                                		</h6>
                                                		<div class="progress progress-md p-0">
                                                			<div class="progress-bar" style="width: '. this_job_complet_rate($job->id) .'%; background-color: '. (this_job_complet_rate($job->id) <= 50 ? '#17a2b8' : '#22ab59') .';"></div>
                                                		</div>
                                                	</div>
                                                </div>
                                			</div>
                                		</div>
                                	<div class="col-lg-2 col-md-2 col-4 text-center text-success">
                                	<h5 style="color: #2ECC71; font-size: 15px;">
                                		'. number_format($job->each_worker_earn, 4) .' $
                                	</h5>
                                </div>
                                
                                </div>
                            </a>
                    ';
                }
            }
        }

        return $html;
    }

    public function get_job_category_wise(Request $request)
    {
        $category_id = $request->category_id;
        $html = '';
        $jobs = Job::where('category_id', $category_id)->where('status', 1)->latest()->limit(100)->get();

        $category_wise_total_found = $jobs->filter(function ($job) {
        return $job->worker_need > $job->worker_confirmed && 
               $job->worker_need > complete_work_this_job($job->id) && 
               work_by_me($job->id) == 0 && 
               work_for_me($job->id) == 1 && $job->pause == 0;
        })->count();
        
        $html .= '<h6 class="text-center">Total Found: ' . $category_wise_total_found . '</h6>';
        
        if($jobs->count() > 0){
            foreach ($jobs as $key=>$job){
                if ($job->worker_need > $job->worker_confirmed && $job->worker_need > complete_work_this_job($job->id) && work_by_me($job->id) == 0 && work_for_me($job->id) == 1 && $job->pause == 0){
                    $html .= '
                            <a href="'.route('job-details', $job->code).'">
                                <div class="border p-1 mb-2 row job-area">
                                	<div class="col-lg-4 col-md-5 col-12 job_title" style="color: '. (this_job_complet_rate($job->id) <= 95 ? 'black' : '#2ECC71') .'; font-weight: 500; font-size: 16px;">'. $job->title .'</div>
                                		<div class="col-lg-6 col-md-5 col-8">
                                			<div class="row m-0 justify-content-end">
                                				<div class="col-lg-6 col-md-5 col-6">
                                                	<div class="text-center mx-auto">
                                                		<h6 class="mt-1" style="color: black; font-size: 10px; font-weight: 250;">
                                                			'. complete_work_this_job($job->id) .' OF '. $job->worker_need .'
                                                		</h6>
                                                		<div class="progress progress-md p-0">
                                                			<div class="progress-bar" style="width: '. this_job_complet_rate($job->id) .'%; background-color: '. (this_job_complet_rate($job->id) <= 50 ? '#17a2b8' : '#22ab59') .';"></div>
                                                		</div>
                                                	</div>
                                                </div>
                                			</div>
                                		</div>
                                	<div class="col-lg-2 col-md-2 col-4 text-center text-success">
                                	<h5 style="color: #2ECC71; font-size: 15px;">
                                		'. number_format($job->each_worker_earn, 4) .' $
                                	</h5>
                                </div>
                                
                                </div>
                            </a>
                    ';
                }
            }
        }

        return $html;
    }

    public function get_load_more_job(Request $request)
    {
        $last_id = $request->last_id;
        $new_last_id = '';
        $html = '';
        $jobs = Job::where('id', '<', $last_id)->where('status', 1)->orderBy('id', 'DESC')->limit(100)->get();

        if($jobs->count() > 0){
            foreach ($jobs as $key=>$job){
                if ($job->worker_need > $job->worker_confirmed && $job->worker_need > complete_work_this_job($job->id) && work_by_me($job->id) == 0 && work_for_me($job->id) == 1 && $job->pause == 0){
                    $new_last_id = $job->id;
                    $html .= '
                            <a href="'.route('job-details', $job->code).'">
                                <div class="border p-1 mb-2 row job-area">
                                	<div class="col-lg-4 col-md-5 col-12 job_title" style="color: '. (this_job_complet_rate($job->id) <= 95 ? 'black' : '#2ECC71') .'; font-weight: 500; font-size: 16px;">'. $job->title .'</div>
                                		<div class="col-lg-6 col-md-5 col-8">
                                			<div class="row m-0 justify-content-end">
                                				<div class="col-lg-6 col-md-5 col-6">
                                                	<div class="text-center mx-auto">
                                                		<h6 class="mt-1" style="color: black; font-size: 10px; font-weight: 250;">
                                                			'. complete_work_this_job($job->id) .' OF '. $job->worker_need .'
                                                		</h6>
                                                		<div class="progress progress-md p-0">
                                                			<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: '. this_job_complet_rate($job->id) .'%; background-color: '. (this_job_complet_rate($job->id) <= 50 ? '#17a2b8' : '#22ab59') .';"></div>
                                                		</div>
                                                	</div>
                                                </div>
                                			</div>
                                		</div>
                                	<div class="col-lg-2 col-md-2 col-4 text-center text-success">
                                	<h5 style="color: #2ECC71; font-size: 15px;">
                                		'. number_format($job->each_worker_earn, 4) .' $
                                	</h5>
                                </div>
                                
                                </div>
                            </a>
                    ';
                }
            }
        }

        return ['html'=>$html, 'last_id'=>$new_last_id];
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // if( Auth::user()->is_ban == 1 && suspend_url_status('job-create') == 1){
        $currenturl = url()->current();
        if( Auth::user()->is_ban == 1 && suspend_url_status($currenturl) == 1){
            return redirect()->route('user.account-suspended');
        }
        
        $continents = Continent::orderBy('id', 'ASC')->get();
        $countrys = Country::orderBy('id', 'ASC')->get();
        $categorys = Category::orderBy('id', 'ASC')->get();
        $job_fee = JobFee::latest()->first();
        $title = 'Add new job';

        return view('user.pages.job-create', compact('continents', 'countrys', 'categorys', 'job_fee', 'title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // return $request;
        $request->validate([
            'title' => 'required',
            'continent' => 'required',
            'category_id' => 'required',
            'sub_category' => 'required',
            'specific_task' => 'required',
            'required_proof' => 'required',
            'worker_need' => 'required',
            'each_worker_earn' => 'required',
            'required_screenshots' => 'required',
            'estimited_day' => 'required',
            'budget' => 'required',
            'thumbnail' => 'mimes:jpg,jpeg,png|max:1024',
        ]);
        
        // return $request;

        $website = Website::latest()->first();
        
        $request->session()->forget('job_error');
        $request->session()->flash('job_error', true);

        $job_cost = $request->budget;
        if(Auth::user()->deposit_balance < $job_cost){
            return redirect()->back();
        }else{
            $user_balance = User::find(Auth::user()->id);
            $user_balance->deposit_balance = $user_balance->deposit_balance - $job_cost;
            $user_balance->save();

            $main_wallet = MainWallet::latest()->first();
            $main_wallet->amount = $main_wallet->amount + $job_cost;
            $main_wallet->save();
        }

        $last_ac = Job::select('id')->latest()->first();

        if (isset($last_ac)) {
            $code = sprintf($last_ac->id + 1);
        } else {
            $code = '1';
        }

        $job = new Job();
        $job->code = $code;
        $job->title = $request->title;
        $job->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $request->title))).'-'.uniqid();
        $job->continent_id = $request->continent;
        $job->category_id = $request->category_id;
        $job->sub_category = $request->sub_category;
        $job->specific_task = trim(implode("|",$request->specific_task),"|");
        $job->required_proof = $request->required_proof;

        $image = $request->file('thumbnail');
        if ($image) {
            $image_name = Str::random(20);
            $ext = strtolower($image->getClientOriginalExtension());
            $image_full_name = $image_name.'.'.$ext;
            $upload_path = 'backend/img/job/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            $job->thumbnail_image = $image_url;
        }

        $max_reject = ceil(($request->worker_need * $website->job_work_reject_ratio) / 100);

        $job->worker_need = $request->worker_need;
        $job->max_reject = $max_reject;
        $job->each_worker_earn = $request->each_worker_earn;
        $job->required_screenshots = $request->required_screenshots;
        $job->estimited_day = $request->estimited_day;
        $job->budget = $request->budget;
        $job->user_id = Auth::user()->id;
        $job->save();
        
        $check_job = Job::where('code', $code)->first();
        if($check_job && $request->country_id){
            foreach($request->country_id as $country_id){
                $job_country = new JobCountry();
                $job_country->job_id = $check_job->id;
                $job_country->country_id = $country_id;
                $job_country->save();
            }
        }
        
        $request->session()->forget('job_error');
        $request->session()->flash('job_success', true);

        return redirect()->back();
    }
    
    public function job_post_done()
    {
        job_delete(Auth::user()->id);
        $datas = Job::where('user_id', Auth::user()->id)->where('status', '!=', 2)->latest()->paginate(25);
        $title = 'Job Post Done';

        return view('user.pages.job-post-done', compact('title', 'datas'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     
     public function edit($id)
    {
        $location_zone = LocationZone::orderBy('id', 'ASC')->get();
        $categorys = Category::orderBy('id', 'ASC')->get();
        $job = Job::find($id);
        $job_countrys = LocationZoneCountry::where('zone_id', $job->location_zone_id)->orderBy('id', 'ASC')->get();
        $job_sub_cats = SubCategory::where('category_id', $job->category_id)->orderBy('id', 'ASC')->get();
        $job_fee = JobFee::latest()->first();
        $title = 'Update job';

        return view('user.pages.job-edit', compact('location_zone', 'job_countrys', 'job', 'job_fee', 'categorys', 'job_sub_cats', 'title'));
    }

    public function job_work_need_update(Request $request, $id)
    {
        $request->validate([
            'worker' => 'required',
        ]);

        $job_fee = JobFee::latest()->first();
        $job = Job::find($id);

        $total_cost = $job->each_worker_earn * $request->worker;
        $fee = (floatval($total_cost) * floatval($job_fee->fee)) / 100;
        $budget = $total_cost + $fee;

        if(Auth::user()->deposit_balance < $budget){
            return redirect()->back()->with('error','You have no sufficient balance');
        }else{
            $user_balance = User::find(Auth::user()->id);
            $user_balance->deposit_balance = $user_balance->deposit_balance - $budget;
            $user_balance->save();

            $main_wallet = MainWallet::latest()->first();
            $main_wallet->amount = $main_wallet->amount + $budget;
            $main_wallet->save();
        }

        $job->worker_need = $job->worker_need + $request->worker;
        $job->save();

        return redirect()->back()->with('message','Job worker updated successfully');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'location_zone_country' => 'required',
            'category_id' => 'required',
            'sub_category' => 'required',
            'specific_task' => 'required',
            'required_proof' => 'required',
            'worker_need' => 'required',
            'each_worker_earn' => 'required',
            'required_screenshots' => 'required',
            'estimited_day' => 'required',
            'budget' => 'required',
        ]);

        $job = Job::find($id);
        $job->title = $request->title;
        $job->location_zone_country = $request->location_zone_country;
        $job->category_id = $request->category_id;
        $job->sub_category = $request->sub_category;
        $job->specific_task = trim(implode("|",$request->specific_task),"|");
        $job->required_proof = $request->required_proof;

        $image = $request->file('thumbnail');
        if ($image) {
            if(file_exists($job->thumbnail_image)){
                unlink($job->thumbnail_image);
            }
            $image_name = Str::random(20);
            $ext = strtolower($image->getClientOriginalExtension());
            $image_full_name = $image_name.'.'.$ext;
            $upload_path = 'backend/img/job/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            $job->thumbnail_image = $image_url;
        }

        $job->worker_need = $request->worker_need;
        $job->each_worker_earn = $request->each_worker_earn;
        $job->required_screenshots = $request->required_screenshots;
        $job->estimited_day = $request->estimited_day;
        $job->budget = $request->budget;
        $job->save();

        return redirect()->back()->with('message','Job updated successfully');
    }
    
    public function pause_job(Request $request, $id)
    {
       
        $job = Job::findOrFail($id);
        
        // Create a user message
        $userMessage = new UserMessage();
        $userMessage->user_id = $job->user_id;
        $userMessage->message_title = 'JOB_PAUSED';
        $userMessage->message = 'Your Job: '.$job->title.' is now Paused. Please Resume for workers';
        $userMessage->save();
    
        // Update the 'pause' property to 1 (paused)
        $job->update(['pause' => 1]);
        
        $request->session()->flash('paused_success', true);
    
        return redirect()->back();
    }

    public function start_job(Request $request, $id)
    {
       
        $job = Job::findOrFail($id);

        // Update the 'pause' property to 0 (resumed)
        $job->update(['pause' => 0]);
        
        $request->session()->flash('resume_success', true);

        return redirect()->back();
    }
    
    public function job_boosting_update($id, Request $request)
    {
        $job = Job::findOrFail($id);
    
        if (job_ready_for_boost($job->id) == 1) {
            $request->validate([
                'boost_charge' => 'required|exists:boost_charges,id',
            ]);
    
            $boostCharge = BoostCharge::findOrFail($request->input('boost_charge'));
            $boostCost = $boostCharge->charge;
    
            if (Auth::user()->deposit_balance >= $boostCost) {
                Auth::user()->decrement('deposit_balance', $boostCost);
    
                $job->update([
                    'boosted_at' => now(),
                    'boosting_interval' => now()->addMinutes($boostCharge->duration),
                ]);
    
                return redirect()->back()->with('message', 'Job boosted successfully');
            } else {
                return redirect()->back()->with('error', 'Insufficient balance for boosting');
            }
        } else {
            return redirect()->back()->with('error', 'Job not ready for boosting');
        }
    }

    public function job_report(Request $request, $id)
    {
        $request->validate([
        'job_id' => 'required',
        'report_describe' => 'required',
    ]);

        $job = Job::find($request->job_id);
        $reportingUser = Auth::user();
    
        $msg_title = $job->title;
    
        $userMessage = new UserMessage();
        $userMessage->user_id = $job->user_id;
        $userMessage->message_title = 'JOB_REPORTED';
        $userMessage->message = 'You Got Report (' . $request->report_describe . ') From: ' . $msg_title;
        $userMessage->save();
        
        $user_message = new UserMessage();
        $user_message->user_id = Auth::user()->id;
        $user_message->message_title = 'SYSTEM_REPLY';
        $user_message->message = 'Thanks! We will take action against your report: (' . $request->report_describe . ')';
        $user_message->save();

        return redirect()->back()->with('message', 'Job reported successfully');
    }
    
    

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $job = Job::find($id);
        if(file_exists($job->thumbnail_image)){
            unlink($job->thumbnail_image);
        }
        $job->delete();

        return redirect()->back()->with('message','Job deleted successfully');
    }
}
